#ifndef __ADRENALIN__CFGPARSE__HEADER__
#define __ADRENALIN__CFGPARSE__HEADER__

const int LINE_SIZE = 1024;


struct SLineAtom {
    LPTSTR	m_szValue;    
};


class CCfgParser {
public:
    CCfgParser();
    CCfgParser(LPCTSTR szFileName);
    ~CCfgParser();
    bool  Open(LPCTSTR szFileName);
    void  Close();
    bool  Failed() const { return (m_fError); }
    bool  Eof()    const { return (m_inStream.eof() != 0); }
    void  ReadLine();
    int   Count() const { return (m_iNumberOfAtoms); }
    LPTSTR operator [] (int i);
    LPTSTR String() const { return ((LPTSTR)m_szBuf); }
    inline int GetLine() const { return (m_iLine); }
    /* @return position of i-th atom in the last read line or -1 if i is incorrect
     */
    int	Where(int i);

    /**
     * Logs error in format
     * <error message> in file <current file> at line <current line>
     */
    void LogError(LPCTSTR szErrorMessage);
private:
    TCHAR			m_szFileName[MAX_PATH];
    int				m_iLine;
	ifstream		m_inStream;
    bool			m_fError;
    bool			m_fOpened;
    char			m_szOemBuf[LINE_SIZE];
    TCHAR			m_szBuf[LINE_SIZE];
    int				m_iNumberOfAtoms;
    vector<LPTSTR>	m_vLineAtoms;
    vector<int>		m_viPositions;

    void ParseLine();
    void FreeLineMemory();
};

#endif
